/*
=======================================================================================
'Job.................:  
'Função..............: 
'Objetivo............: Incluir registro na pendencia para conciliação. Registros de Cupom fiscal
'Tabelas.............: 
'Dt Modificação......: 20/01/2021
'Modificação.........: 
'=======================================================================================
Tag #A001 - Alteração do codigo  
Tag #I001 - Inclusão de novo codigo 
*/ 
IF OBJECT_ID('PDV_VD_TEF_PEND') IS NULL 
BEGIN 
	 CREATE TABLE PDV_VD_TEF_PEND (
		ID_CTR				BIGINT IDENTITY (1,1), 
		CD_EMP				INT, 
		CD_FILIAL			INT,
	    CD_VD				INT,
		CD_CTR 				BIGINT,
		DT_CAD				DATETIME, 

		CONSTRAINT PK_PDV_VD_TEF_PEND PRIMARY KEY (ID_CTR)
	 )
END 

GO 
IF EXISTS (SELECT * FROM SYS.TRIGGERS WHERE OBJECT_ID = OBJECT_ID(N'[DBO].[TRG_PDV_VD_TEF_ULT_MOV]') )
BEGIN 	
	DROP TRIGGER [DBO].[TRG_PDV_VD_TEF_ULT_MOV];
END 
GO

CREATE TRIGGER [DBO].[TRG_PDV_VD_TEF_ULT_MOV] ON [DBO].[PDV_VD_TEF]
FOR  INSERT 
AS 
BEGIN 

 INSERT INTO PDV_VD_TEF_PEND (CD_EMP, CD_FILIAL, CD_VD, CD_CTR,DT_CAD)
 SELECT  
		INSERTED.CD_EMP,
		INSERTED.CD_FILIAL,
		INSERTED.CD_VD,
		INSERTED.CD_CTR,
		GETDATE ()
	FROM
		INSERTED  
		LEFT JOIN PDV_VD_TEF_PEND  ON PDV_VD_TEF_PEND.CD_EMP	  = INSERTED.CD_EMP
								   AND PDV_VD_TEF_PEND.CD_FILIAL  = INSERTED.CD_FILIAL
							       AND PDV_VD_TEF_PEND.CD_VD      = INSERTED.CD_VD
								   AND PDV_VD_TEF_PEND.CD_CTR     = INSERTED.CD_CTR
  WHERE INSERTED.CD_EMP = 1
    AND PDV_VD_TEF_PEND.CD_EMP IS NULL


--SELECT * FROM GLB_DT_MOVIMENTO WHERE CD_CTR_DT_MOVIMENTO  = 1296
  

END 